;;;  Dateiname: Sideboard-r.lsp  -  erstellt: Thomas Elbracht
;;;  7.2023  -  fr AC2023               mail: te@elbracht-web.de
;;;  Aufruf mit: sideboard-r
;;;
;;;  Die Routine erstellt ein Sideboard fr den Einrichtungsplaner
;;
  (defun Te:Sideboard-rIni ()
  ; speichert die Variablen
  (if *error*				
    (setq *te:error* *error*)		
  )
    
  (setq cealt (getvar "CMDECHO")
        mealt (getvar "MENUECHO")
	osalt (getvar "OSMODE")
	ortalt (getvar "ORTHOMODE")
	layalt (getvar "CLAYER")
	Layalt (getvar "CLAYER")
	coalt (getvar "CECOLOR")
	delalt (getvar "DELOBJ")
	)
  
  	(setvar "CMDECHO" 0)
	(setvar "MENUECHO" 0)
        (setvar "OSMODE" 0)
        (setvar "ORTHOMODE" 0)
        (setvar "DELOBJ" 2)
  	
  (defun *error* (sTxt)	
    (princ (strcat "\n" sTxt))

  (setvar "CMDECHO" cealt)
  (setvar "MENUECHO" mealt)
 
    (if	*te:error*
      (setq *error* *te:error*)	
      (setq *error* nil)
    )
    (princ)
  )
nil
)
(defun Te:Sideboard-rDlg ()

(setq next 4)
(setq	IMG1 "Sideboard-r(logo)"
	fil1 IMG1) 
(if (not dcl_id) (setq dcl_id (load_dialog "Sideboard-r")))
  (while (> next 1)
  (new_dialog "SIDEBOARD_R" dcl_id)

	(setq brei (dimx_tile "DIA"))
    	(setq hoe (dimy_tile "DIA"))
    	(start_image "DIA")
    	(fill_image 0 0 brei hoe -2)
    	(slide_image -20 -350 480 650 "Sideboard-r(sideboard-r)")
	(end_image)
 
    (start_image "IMG1") 
    (slide_image 150 -35 180 130 fil1)
    (end_image)

    (set_tile "DSB" (rtos SB 2 0))
    (set_tile "DSH" (rtos SH 2 0))
    (set_tile "DST" (rtos ST 2 0))
    (set_tile "DSBH" (rtos SBH 2 0))
    (set_tile "DUEBP" (rtos UEBP 2 0))
    (set_tile "DMaDoP" (rtos MaDoP 2 0))
    (set_tile "DMaD" (rtos MaD 2 0))
    (set_tile "DAbBo" (rtos AbBo 2 0))
    (set_tile "DRwD" (rtos RwD 2 2))
    (set_tile "DEBodAnz" (rtos EBodAnz 2 0))
    (set_tile "DGrifH" (rtos GrifH))
    (set_tile "DGrifS" (rtos GrifS))
(if (= DTur 0) (progn(set_tile "DTur0" "1")(set_tile "DTur1" "0")))
(if (= DTur 1) (progn(set_tile "DTur0" "0")(set_tile "DTur1" "1")))
    (set_tile "DTurFug" (rtos TurFug 2 2))
    (action_tile "DSB" "(setq SB (atof $value))")
    (action_tile "DSH" "(setq SH (atof $value))")
    (action_tile "DST" "(setq ST (atof $value))")
    (action_tile "DSBH" "(setq SBH (atof $value))")
    (action_tile "DUEBP" "(setq UEBP (atof $value))")
    (action_tile "DMaDoP" "(setq MaDoP (atof $value))")
    (action_tile "DMaD" "(setq MaD (atof $value))")
    (action_tile "DAbBo" "(setq AbBo (atof $value))")
    (action_tile "DRwD" "(setq RwD (atof $value))")
    (action_tile "DEBodAnz" "(setq EBodAnz (atof $value))")
    (action_tile "DGrifH" "(setq GrifH (atof $value))")
    (action_tile "DGrifS" "(setq GrifS (atof $value))")
    (action_tile "DTur0" "(DO_Tur0 $value)")
    (action_tile "DTur1" "(DO_Tur1 $value)")
    (action_tile "DTurFug" "(setq TurFug (atof $value))")
    (action_tile "accept" "(done_dialog 1)")
    (action_tile "cancel" "(done_dialog 0)")
(setq next (start_dialog))

    (if (= next 1) 
  (Te:Sideboard-rZeich)
  (Te:Sideboard-rBack)
  )
    )
  (unload_dialog dcl_id)
)
(defun Te:Sideboard-rZeich ()
(vl-load-com)

  (vl-cmdf "_.view" "S" "TE_VIEW")
  (vl-cmdf "_.UCS" "")
  (vl-cmdf "_.PLAN" "W")   

  (setq EP (getpoint "\n Einfgepunkt angeben, hinten links"))
  (command-s "LAYER" "_M" "Te_Sideboard-r" "_CO" "33" "Te_Sideboard-r" "")

  (setq SB2 (/ SB 2.0))(setvar "osmode" 0)
 (setq PuPLH (list (car EP)(cadr EP)(-(+(caddr EP)AbBo SH) MaDoP))
       PuPLV (list (car EP)(- (cadr EP) ST)(caddr PuPLH))
       PuPRH (list (+(car EP)SB)(cadr EP)(caddr PuPLH))
       PuPRV (list (car PuPRH)(-(cadr EP)ST)(caddr PuPLH))
       PuPMV (list (+(car EP)SB2)(-(cadr EP)(+ ST SBH))(caddr PuPLH)))

    (vl-cmdf "_arc" PuPLV PuPMV PuPRV)
 (setq obj (entget (setq arcob (entlast))))
	
  (if (= (dxf 0 obj) "ARC")
		(progn (setq MI (dxf 10 obj) Ra (dxf 40 obj))
      ))
  (vl-cmdf "_erase" arcob "")
  
(vl-cmdf "_pline" PuPLH PuPRH PuPRV "k" "p" PuPMV PuPLV "li" "s")
 (setq OPlat (entlast))
  (vl-cmdf "_extrude" OPlat "" MaDoP)

 (setq PuPLHu (list (car EP)(cadr EP)(+(caddr EP)AbBo))
       PuPLVu (list (car EP)(+(- (cadr EP) ST)UEBP MaD)(caddr PuPLHu))
       PuPRHu (list (+(car EP)SB)(cadr EP)(caddr PuPLHu))
       PuPRVu (list (car PuPRH)(cadr PuPLVu)(caddr PuPLHu))
       PuPMVu (list (car MI)(+(-(cadr EP)ST SBH)UEBP MaD)(caddr PuPLHu)))

   (vl-cmdf "_pline" PuPLHu PuPRHu PuPRVu "k" "p" PuPMVu PuPLVu "li" "s")
   (setq UPlat (entlast))(vl-cmdf "_extrude" UPlat "" MaD)

  (vl-cmdf "zoom" "G")
  (setq RaFrv (- Ra UEBP) RaFrh (- RaFrv MaD))

  (cond ((= DTur 0)   ; Tr - Einlegebden
    (if (> EBodAnz 0)(Te:Sideboard_rEBod)
      )
	 (Te:Sideboard-rTurLi)
	 )
	((= DTur 1)   ; Einlegebden - Tr
	 (if (> EBodAnz 0)(Te:Sideboard_rEBod)
      )
	 (Te:Sideboard-rTurRe)
	 )
	)
  (Seiten)
)
(defun Te:Sideboard-rTurLi ()
    (setq PuTuvL (list (car EP)(+(- (cadr EP) ST)UEBP)(caddr PuPMVu))
	PuTuvR (list (car PuPMVu)(- (cadr PuPMVu) MaD)(caddr PuPMVu)))
	
(setq distL (distance PuPMVu PuPLVu))
    (E_Angle PuPMVu PuPLVu)
    (setq linHMi (polar PuPMVu angB(/ distL 2.0)))
    (E_Angle  MI linHMi)
    (setq BogMiH (polar MI angB RaFrh))
    (vl-cmdf "_arc" PuPLVu BogMiH PuPMVu)(setq ArcH (entlast))

    (setq distL (distance PuTuvL PuTuvR))
    (E_Angle PuTuvL PuTuvR)    
    (setq linVMi (polar PuTuvL angB(/ distL 2.0)))
    (E_Angle  MI linVMi)
    (setq BogMiV (polar MI angB RaFrv))
    (vl-cmdf "_arc" PuTuvL BogMiV PuTuvR)(setq ArcV (entlast))
    (vl-cmdf "_line" PuPLVu PuTuvL "")(setq linL (entlast))
    (vl-cmdf "_line"  PuTuvR PuPMVu "")(setq linR (entlast))
    (vl-cmdf "region" linR ArcV ArcH linL "")(setq TurBogL (entlast))
   (vl-cmdf "_extrude" TurBogL "" (- SH MaDoP TurFug))
   (Te:SplGriff)
  (setq GrEP (list (car PuTuvR)(cadr PuTuvR)(+(caddr PuTuvR) (- SH MaDoP TurFug GrifH))))
  (vl-cmdf "_move" Grif "" SplPu1 GrEP)

  (setq GriWr (list (car PuTuvR)(cadr PuTuvR)(caddr GrEP))
	GriWl (list (car BogMiV)(cadr BogMiV)(caddr GrEP)))

  (E_Angle GriWr GriWl)(setq GriWN (polar GriWr angB GrifS))(E_Angle MI GriWN)
  (setq GrEP2 (polar MI angB RaFrv))
  (vl-cmdf "_rotate" Grif "" MI "b" MI GrEP GrEP2)
)
(defun Te:Sideboard_rEBod ()
	(setq RegIn (- SH MaDoP MaD))
    (setq EBodAnz (fix EBodAnz))
  (setq AeBod (/ (- RegIn (* EBodAnz MaD)) (+ EBodAnz 1)))
  		(if (> EBodAnz 0)
		 (progn
			(setq e 1)
			 (while (/= e (+ EBodAnz 1))
		(if (= DTur 1)(progn
		(setq EBodLH (list (+(car EP)MaD)(-(cadr EP)RwD)(+(caddr EP)AbBo (* (+ AeBod MaD) e))))
				(Te:Sideboard_rEBodL))
		  (progn
		(setq EBodLH (list (+(car EP)SB2)(-(cadr EP)RwD)(+(caddr EP)AbBo (* (+ AeBod MaD) e))))
		  (Te:Sideboard-rEBodR))
			   )
			   (setq e (+ e 1))
			 )
		 )	
		)
)
(defun Te:Sideboard-rEBodR ()
    (setq boghr (list (car PuPRV)(+(cadr PuPRV)UEBP MaD)(caddr EP))
	  boghl (list (car PuPMV)(+(cadr PuPMV)UEBP MaD)(caddr EP))
	  bogvr (list (car PuPRV)(+(cadr PuPRV)UEBP)(caddr EP))
	  bogvl (list (car PuPMV)(+(cadr PuPMV)UEBP)(caddr EP)))

    (setq PuPMV (list (+(car EP)SB2)(-(cadr EP)(+ ST SBH))(caddr EP)))
    (setq hintMeP (list (+(car EP)(/ SB 2.0)) (cadr EP)(caddr EP))
	PuPMVm (list (car PuPMV)(+(cadr PuPMV)UEBP)(caddr EP))
	PuPMHm (list (car PuPMVm)(+(cadr PuPMVm)MaD)(caddr EP)))
  
(setq EBodLV (list (car EBodLH)(+(- (cadr EP) ST SBH)UEBP MaD 10.0)(caddr EBodLH))
       EBodRH (list (-(+(car EP)SB)MaD)(cadr EBodLH)(caddr EBodLH))
       EBodRV (list (car EBodRH)(+(-(cadr EP)ST) UEBP  MaD 10.0)(caddr EBodLH))
       MIEBod (list(car MI)(cadr MI)(caddr EBodLH)))

    (setq distLl (distance EBodLV EBodRV) RaEBod (distance MIEBod EBodRV))
    (E_Angle EBodLV EBodRV)
    (setq EBodVMi (polar EBodLV angB(/ distLl 2.0)))
    (E_Angle MIEBod EBodVMi)
    (setq BodBogMiV (polar MIEBod angB RaEBod))
  
  (vl-cmdf "_pline" EBodLH EBodRH EBodRV "k" "p" BodBogMiV EBodLV "li" "s")
   (setq EBodO (entlast))(vl-cmdf "_extrude" EBodO "" MaD)(setq EBodO (entlast))
)
(defun Te:Sideboard_rEBodL ()  
  
 (setq boghr (list (car PuPRV)(+(cadr PuPRV)UEBP MaD)(caddr EP))
       boghl (list (car PuPMV)(+(cadr PuPMV)UEBP MaD)(caddr EP))
       bogvr (list (car PuPRV)(+(cadr PuPRV)UEBP)(caddr EP))
       bogvl (list (car PuPMV)(+(cadr PuPMV)UEBP)(caddr EP)))

    (setq PuPMV (list (+(car EP)SB2)(-(cadr EP)(+ ST SBH))(caddr EP)))

  (setq hintMeP (list (+(car EP)(/ SB 2.0)) (cadr EP)(caddr EP))
	PuPMVm (list (car PuPMV)(+(cadr PuPMV)UEBP)(caddr EP))
	PuPMHm (list (car PuPMVm)(+(cadr PuPMVm)MaD)(caddr EP)))
  (setq EBodLV (list (car EBodLH)(+(- (cadr EP) ST)UEBP MaD 9.0)(caddr EBodLH))
        EBodRH (list (+(car EP)SB2)(cadr EBodLH)(caddr EBodLH))
        EBodRV (list (car EBodRH)(+(-(cadr EP)ST SBH)UEBP MaD 10.0)(caddr EBodLH))
        MIEBod (list(car MI)(cadr MI)(caddr EBodLH)))

    (setq distLl (distance EBodLV EBodRV) RaEBod (distance MIEBod EBodRV))
    (E_Angle EBodLV EBodRV)
    (setq EBodVMi (polar EBodLV angB(/ distLl 2.0)))
    (E_Angle MIEBod EBodVMi)
    (setq BodBogMiV (polar MIEBod angB RaEBod))
  
  (vl-cmdf "_pline" EBodLH EBodRH EBodRV "k" "p" BodBogMiV EBodLV "li" "s")
   (setq EBodO (entlast))(vl-cmdf "_extrude" EBodO "" MaD)(setq EBodO (entlast))
)
(defun Te:Sideboard-rTurRe ()
  
(setq distL (distance PuPMVm bogvr))
    (E_Angle PuPMVm bogvr)
    (setq linVMi (polar PuPMVm angB(/ distL 2.0)))
    (E_Angle  MI linVMi)
    (setq BogMiV (polar MI angB RaFrv))
    (vl-cmdf "_arc" PuPMVm BogMiV bogvr)(setq ArcV (entlast))

    (setq distL (distance PuPMHm boghr))
    (E_Angle PuPMVm boghr)    
    (setq linHMi (polar PuPMHm angB(/ distL 2.0)))
    (E_Angle  MI linHMi)
    (setq BogMiH (polar MI angB RaFrh))
    (vl-cmdf "_arc" PuPMHm BogMiH boghr)(setq ArcH (entlast))

    (vl-cmdf "_line" boghl bogvl "")(setq linL (entlast))
    (vl-cmdf "_line"  boghr bogvr "")(setq linR (entlast))
    (vl-cmdf "region" linR ArcV ArcH linL "")(setq TurBogR (entlast))
    (vl-cmdf "_extrude" TurBogR "" (- SH MaDoP TurFug))(setq TurR (entlast))
    (vl-cmdf "_move" TurR "" bogvr (list (car bogvr)(cadr bogvr)(+(caddr bogvr) AbBo)))
   (Te:SplGriff)
  (setq GrEP (list (car bogvl)(cadr bogvl)(+(caddr bogvl) AbBo (- SH MaDoP TurFug GrifH))))
  (vl-cmdf "_move" Grif "" SplPu1 GrEP)

  (setq GriWl (list (car bogvl)(cadr bogvl)(caddr GrEP))
	GriWr (list (car BogMiV)(cadr BogMiV)(caddr GrEP)))

  (E_Angle GriWl GriWr)(setq GriWN (polar GriWl angB GrifS))(E_Angle MI GriWN)
  (setq GrEP2 (polar MI angB RaFrv))
  (vl-cmdf "_rotate" Grif "" MI "b" MI GrEP GrEP2)
)
(defun Te:SplGriff()
  (setq SplPu1 (list (+(car EP)10.0)(+(cadr EP) 30.0)(caddr EP))
	SplPu2 (list (+(car EP)6.0)(+(cadr EP)7.0)(caddr EP))
	SplPu3 (list (+(car EP)20.0)(+(cadr EP) 4.0)(caddr EP))
	SplPu4 (list (+(car EP)50.0)(+(cadr EP) 11.0)(caddr EP))
	SplPu5 (list (+(car EP)90.0)(+(cadr EP) 32.0)(caddr EP)))
  (vl-cmdf "_spline" SplPu1 SplPu2 SplPu3 SplPu4 SplPu5 "" "" "")(setq spli (entlast))

  (setq BKV1 (list (car EP)(+(cadr EP) 30.0)(caddr EP))
	BKV2 (list (+(car EP)100)(+(cadr EP) 30.0)(caddr EP))
	BKV3 (list (car EP)(+(cadr EP) 30.0)(+(caddr EP)100)))
 (vl-cmdf "_.UCS" "3P" BKV1 BKV2 BKV3)
 (vl-cmdf "_.PLAN" "")
  (setq KrEP (trans SplPu1 0 1))
  (vl-cmdf "_circle" KrEP "5")(setq kre (entlast))
  (vl-cmdf "CECOLOR" 153)	
  (vl-cmdf "_extrude" "MO" "V" kre "" "V" "1.5" "P" spli)(setq grif (entlast))
  (vl-cmdf "CECOLOR" coalt)
  (vl-cmdf "_.UCS" "")
  (vl-cmdf "_.PLAN" "W")
  (vl-cmdf "_slice" grif "" BKV1 BKV2 BKV3 "")
  (vl-cmdf "_erase" (entlast) "")
  (vl-cmdf "_.UCS" "3P" BKV1 BKV2 BKV3)
  (vl-cmdf "_.PLAN" "")
  (vl-cmdf "_rotate" grif "" KrEP "-90")
  (vl-cmdf "_.UCS" "")
  (vl-cmdf "_.PLAN" "W")
)
(defun Seiten ()
(setq SeitBrM (-(+ ST SBH) UEBP MaD RwD))
(setq SeitBrL (- St UEBP MaD))(setq SeitBrR SeitBrL)
    
(Te:Platte (list (car EP)(- (cadr EP) SeitBrL)(+(caddr EP)AbBo MaD)) MaD SeitBrL (- SH MaDoP MaD))

    (if(= DTur 0)
(Te:Platte (list (-(+(car EP)SB2) MaD)(-(cadr EP) SeitBrM RwD)(+(caddr EP)AbBo MaD)) MaD SeitBrM (- SH MaDoP MaD))
(Te:Platte (list (+(car EP)SB2)(-(cadr EP) SeitBrM RwD)(+(caddr EP)AbBo MaD)) MaD SeitBrM (- SH MaDoP MaD))
      )
(Te:Platte (list (-(+(car EP)SB) MaD)(-(cadr EP) SeitBrL)(+(caddr EP)AbBo MaD)) MaD SeitBrR (- SH MaDoP MaD))

    (if (/= RwD 0)	
 (Te:Platte (list (+ (car EP) (- MaD 10))(- (cadr EP) RwD)(+ (caddr EP) (- (+ AbBo MaD) 10))) (+ (- SB (* 2 MaD)) 20) RwD (- SH 20))
 )

  (vl-cmdf "_.view" "H" "TE_VIEW")
  (vl-cmdf "_.zoom" "G" "_.zoom" "0.8x")
  (vl-cmdf "_.view" "L" "TE_VIEW")
  )
(defun E_Angle(AnfLin EndLin)
    (setq lineObj (vlax-get-acad-object))
    (setq doc (vla-get-ActiveDocument lineObj))
    (setq startPoint (vlax-3d-point AnfLin)
          endPoint (vlax-3d-point EndLin))
    (setq modelSpace (vla-get-ModelSpace doc))
    (setq lineObj (vla-AddLine modelSpace startPoint endPoint))
    (setq angB (vla-get-Angle lineObj))(setq ang (bia angB))
    (vl-cmdf "_erase" (entlast) "")
)
(DEFUN dxf (c el) (cdr (assoc c el)))
(DEFUN aib (w) (* pi (/ w 180.0)))(DEFUN bia (Wi) (* 180 (/ Wi Pi)))
(defun E_Arc (CP Ra WA WE)
    (setq arcObj (vlax-get-acad-object))
    (setq doc (vla-get-ActiveDocument arcObj))
    (setq CEN (vlax-3d-point CP))
    (setq modelSpace (vla-get-ModelSpace doc))  
    (setq arcObj (vla-AddArc modelSpace CEN Ra WA WE))
)
(defun E_Line (PA PE)
    (setq lineObj (vlax-get-acad-object))
    (setq doc (vla-get-ActiveDocument LineObj))
    (setq startPoint (vlax-3d-point PA)
          endPoint (vlax-3d-point PE))
    
    (setq modelSpace (vla-get-ModelSpace doc))
    (setq lineObj (vla-AddLine modelSpace startPoint endPoint))
)
(defun DO_Tur0 (in)
(setq Tur_VAL (atof in))
(if (= Tur_VAL 1)  (progn (setq DTur 0)
		     (set_tile "DTur0" "1")(set_tile "DTur1" "0")
		     ))
) 
(defun DO_Tur1 (in)
(setq Tur_VAL (atof in))
(if (= Tur_VAL 1)  (progn (setq DTur 1)
		     (set_tile "DTur0" "0")(set_tile "DTur1" "1")
		     ) )
)
(defun Te:Platte (CP laenge breite hoehe)
    ;; Aufruf fr 3DSolid im Modellbereich
    (setq Sideboard-rObj (vlax-get-acad-object))
    (setq Holzliste (vla-get-ActiveDocument  Sideboard-rObj))
  	(setq px (+(car CP) (/ laenge 2.0)) py (+(cadr CP) (/ breite 2.0))  pz (+ (caddr CP)(/ hoehe 2.0)))
        (setq MP (vlax-3d-point px py pz))
        (setq modelSpace (vla-get-ModelSpace Holzliste))
    (setq PlatteObj (vla-AddBox modelSpace MP laenge breite hoehe))
)
(defun Te:Sideboard-rBack ()
; setzt die Variablen zurck
  
  (setvar "CMDECHO" cealt)
  (setvar "MENUECHO" mealt)
  (setvar "OSMODE"  osalt)
  (setvar "CLAYER"  layalt)
  (setvar "CECOLOR" coalt)
  (setvar "ORTHOMODE" ortalt)
  (setvar "DELOBJ" delalt)
)
(defun C:Sideboard-r ( / dcl_id cealt mealt osalt ortalt layalt coalt delalt SB SH ST SBH UEBP MaDoP MaD AbBo RwD EBodAnz AeBod
		      DTur Dn a TurFug GrifH GrifS next IMG1 fil1 brei hoe EP SB2 PuPLH PuPLV PuPRH PuPRV PuPMV obj arcob MI OPlat
		      PuPLHu PuPRHu PuPRVu PuPMVu PuPLVu UPlat RaFrv RaFrh PuTuvL PuTuvR linHMi BogMiH linVMi BogMiV GrEP GriWr
		      GriWl GrEP2 RegIn e EBodLH boghr boghl bogvr bogvl PuPMV hintMeP PuPMVm PuPMHm EBodLV EBodRH EBodRV MIEBod
		      distLl RaEBod EBodVMi BodBogMiV EBodO BodBogMiV ArcH linL linR TurBogR TurR SplPu1 SplPu2 SplPu3 SplPu4
		      SplPu5 spli BKV1 BKV2 BKV3 KrEP SeitBrM SeitBrL lineObj doc startPoint endPoint modelSpace angB ang arcObj
		      CEN Tur_VAL Sideboard-rObj Holzliste px py pz MP PlatteObj)

  (Te:Sideboard-rIni)
  
(setq SB 1200     ; Sideboard-rbreite
      SH 600      ; Sideboard-rhhe
      ST 400      ; Sideboard-rtiefe
      SBH 50      ; Ausbuchtung 
      UEBP 15     ; berstand obere Platte
      MaDoP 22.0  ; Materialdicke obere Platte
      MaD 19.0    ; Materialdicke
      AbBo 400    ; Abstand vom Boden
      RwD 16      ; Rckwanddicke
      EBodAnz 2   ; Anzahl Einlegebden
      AeBod 361.2 ; Abstand Einlegebden
      DTur 0      ; 0 = Tr links, Einlegebden rechts
                  ; 1 = Einlegebden links, Tr rechts
      TurFug 5.0  ; Trfuge
      GrifH 50.0  ; Trhhe - GrifH
      GrifS 50.0  ; Trbreite - GrifS
      a "0"
)

;  (setq EP '(0.0 0.0 0.0))
 (princ "\n  Copyright (c) 2o23 Thomas Elbracht ")
  (princ "\n  Starten Sie mit dem Befehl << Sideboard-r >>  ")
	(Te:Sideboard-rDlg)
	(Te:Sideboard-rBack)
  	(princ)
  )
  (princ)
